
// SoftwareEncoderDlg.h : header file
//

#pragma once
#include "afxwin.h"


// CSoftwareEncoderDlg dialog
class CSoftwareEncoderDlg : public CDialogEx
{
// Construction
public:
	CSoftwareEncoderDlg(CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	//{{AFX_DATA(CSoftwareEncoderDlg)
	enum { IDD = IDD_SOFTWAREENCODER_DIALOG };
	CStatic			m_statWindow;
	CButton		m_btnStart;
	CButton		m_btnStop;
	//}}AFX_DATA

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support

// Implementation
protected:
	HICON m_hIcon;

	// Generated message map functions
	virtual BOOL OnInitDialog();
	afx_msg void OnDestroy();
	afx_msg void OnPaint();
	afx_msg void OnBnClickedBtnStart();
	afx_msg void OnBnClickedBtnStop();
	afx_msg HCURSOR OnQueryDragIcon();
	DECLARE_MESSAGE_MAP()

public:

	BOOL				HwUnInitialize();

	BOOL				HwInitialize();

	CString				GetWorkingPath( );

public:

	DEVICE_HANDLE				m_hVideoDev;										// VIDEO STREAM CAPTURE DEVICE

	DEVICE_HANDLE				m_hVideoSwEncoderDev;						// H264 SOFTWARE ENCODER DEVICE

	ULONG								m_nFileRendererRecordState;					// FILE RENDERER RECORD STATE (0 = STOP / 1 = ACQUIRE / 2 = START)

	CRITICAL_SECTION			m_hAccessFileCriticalSection;					// FILE ACCESS CRITICAL SECTION

	BOOL									m_bSetBuffer;

	HANDLE 							m_hVideoThreadBufferReadyEvent;

	HANDLE								m_hVideoThread;

	ULONG								m_hVideoThreadNumber;
	
	CStdioFile *							m_pTxtFile;

	CStdioFile *							m_pBinFile;		
};
